Ext.data.JsonP.sol_common_ix_functions_CreateSord({"tagname":"class","name":"sol.common.ix.functions.CreateSord","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.functions.CreateSord.js","href":"sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord"}],"author":[{"tagname":"author","name":"ESt, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloix":true,"requires":["sol.common.AclUtils","sol.common.AsyncUtils","sol.common.IxUtils","sol.common.JsonUtils","sol.common.RepoUtils","sol.common.SordTypeUtils","sol.common.SordUtils","sol.common.Template","sol.common.WfUtils","sol.common.ix.FunctionBase","sol.common.ix.RfUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.FunctionBase","mixins":[],"uses":[],"members":[{"name":"objId","tagname":"cfg","owner":"sol.common.ix.FunctionBase","id":"cfg-objId","meta":{}},{"name":"onCreatedElement","tagname":"cfg","owner":"sol.common.ix.functions.CreateSord","id":"cfg-onCreatedElement","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"sourceElement","tagname":"cfg","owner":"sol.common.ix.functions.CreateSord","id":"cfg-sourceElement","meta":{}},{"name":"targetFolder","tagname":"cfg","owner":"sol.common.ix.functions.CreateSord","id":"cfg-targetFolder","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"_moveFct","tagname":"property","owner":"sol.common.ix.functions.CreateSord","id":"property-_moveFct","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"copyElement","tagname":"method","owner":"sol.common.ix.functions.CreateSord","id":"method-copyElement","meta":{"private":true}},{"name":"createSordFromScratch","tagname":"method","owner":"sol.common.ix.functions.CreateSord","id":"method-createSordFromScratch","meta":{"private":true}},{"name":"finalizeCreatedElement","tagname":"method","owner":"sol.common.ix.functions.CreateSord","id":"method-finalizeCreatedElement","meta":{"private":true}},{"name":"getServiceResult","tagname":"method","owner":"sol.common.ix.functions.CreateSord","id":"method-getServiceResult","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.FunctionBase","id":"method-initialize","meta":{"private":true}},{"name":"moveElement","tagname":"method","owner":"sol.common.ix.functions.CreateSord","id":"method-moveElement","meta":{"private":true}},{"name":"prepareSourceElement","tagname":"method","owner":"sol.common.ix.functions.CreateSord","id":"method-prepareSourceElement","meta":{"private":true}},{"name":"prepareTargetFolder","tagname":"method","owner":"sol.common.ix.functions.CreateSord","id":"method-prepareTargetFolder","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.functions.CreateSord","id":"method-process","meta":{}},{"name":"setElementPermissions","tagname":"method","owner":"sol.common.ix.functions.CreateSord","id":"method-setElementPermissions","meta":{"private":true}},{"name":"startWorkflowOnElement","tagname":"method","owner":"sol.common.ix.functions.CreateSord","id":"method-startWorkflowOnElement","meta":{"private":true}},{"name":"RF_sol_function_CreateSord","tagname":"method","owner":"sol.common.ix.functions.CreateSord","id":"static-method-RF_sol_function_CreateSord","meta":{"static":true}},{"name":"onEnterNode","tagname":"method","owner":"sol.common.ix.functions.CreateSord","id":"static-method-onEnterNode","meta":{"static":true}},{"name":"onExitNode","tagname":"method","owner":"sol.common.ix.functions.CreateSord","id":"static-method-onExitNode","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.functions.CreateSord","short_doc":"Creates a sord in the chaos cabinet (0) based on a template or from scratch. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a><div class='subclass '><strong>sol.common.ix.functions.CreateSord</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.AclUtils' rel='sol.common.AclUtils' class='docClass'>sol.common.AclUtils</a></div><div class='dependency'><a href='#!/api/sol.common.AsyncUtils' rel='sol.common.AsyncUtils' class='docClass'>sol.common.AsyncUtils</a></div><div class='dependency'><a href='#!/api/sol.common.IxUtils' rel='sol.common.IxUtils' class='docClass'>sol.common.IxUtils</a></div><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordTypeUtils' rel='sol.common.SordTypeUtils' class='docClass'>sol.common.SordTypeUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord' target='_blank'>sol.common.ix.functions.CreateSord.js</a></div></pre><div class='doc-contents'><p>Creates a sord in the chaos cabinet (0) based on a template or from scratch. Executes specified actions on the created element.\nReturns the objId (and flowId, if a workflow has been started) of the created element if called as an RF.</p>\n\n<p>Usually, this function will be used in conjunction with <a href=\"#!/api/sol.common.ix.functions.FillSord\" rel=\"sol.common.ix.functions.FillSord\" class=\"docClass\">FillSord</a>, which\ncan be used to fill metadata-fields of the created sord. (CreateSord can be called from within FillSord)</p>\n\n<h3>Creating a sord using a template</h3>\n\n<p>A template can be copied, resulting in a new sord.</p>\n\n<pre><code>{\n  sourceElement: { objId: \"ARCPATH:/path/to/my/template\" }\n}\n</code></pre>\n\n<p>Optionally, the templates permissions (acl) can be applied to the created sord:</p>\n\n<pre><code>{\n  sourceElement: { objId: \"ARCPATH:/path/to/my/template\" },\n  options: { copySourceAcl: true }\n}\n</code></pre>\n\n<h3>Creating a sord from scratch</h3>\n\n<p>If no template is available, the following can be used to create a new sord from scratch</p>\n\n<pre><code>{\n  sourceElement: { fromScratch: { mask: \"Basic Entry\", type: \"sol.mytype\" } }\n}\n</code></pre>\n\n<h3>Retrieving an objId from a service</h3>\n\n<p>If the sord creation requires a more sophisticated process than a simple template-copy or <code>fromScratch</code>,\none can define an IX-RF-service/function which e.g. speaks to external systems and returns the objId\nof the created sord.</p>\n\n<pre><code>{\n  sourceElement: {\n    fromService: { name: \"RF_CreateSordByDate\", params: { a: \"x\", b: \"z\"} }\n  }\n}\n\n// this service must return one of the following objects:\n{ objId: \"123456\" }\n{ fromScratch: { mask: \"Basic Entry\", type: undefined } } // type is optional\n</code></pre>\n\n<h3>Moving the created sord into a folder</h3>\n\n<p>As a default, the sord is created in the chaos cabinet (objId 0), however, one must define\nan objId/ARCPATH/GUID. The created sord will then be moved into this folder after creation.\nIt is possible to define \"0\" here, if one wants to leave the created sord in the chaos cabinet.</p>\n\n<pre><code>{ targetFolder: { objId: \"ARCPATH:/where/all/my/sords/go\" } }\n</code></pre>\n\n<h3>Determining the targetFolder objId from a service</h3>\n\n<p>A Service can be defined instead of specifying a fixed path/objId</p>\n\n<pre><code>{\n  targetFolder: {\n    fromService: { name: \"RF_PrepareTargetFolder\", params: { a: \"x\", b: \"z\"} }\n  }\n}\n\n// this service must return an object having an objId property:\n{ objId: \"123456\" }\n</code></pre>\n\n<h3>Setting Permissions</h3>\n\n<p>Permissions are set while copying the template or after creating the sord from scratch.</p>\n\n<pre><code>{\n  onCreatedElement: {\n    setPermissions: {\n      users: [ { name: \"MY_GROUP\", rights: { r: true, w: true } } ],\n      recursive: true,\n      mode: \"SET\"\n    }\n  }\n}\n</code></pre>\n\n<h3>Starting a workflow</h3>\n\n<p>A workflow can be started by defining the workflow template name and optionally a title</p>\n\n<pre><code>{\n  onCreatedElement: {\n    startWorkflow: { name: \"sol.mymodule.workflow\", title: \"this is a workflow title\" }\n  }\n}\n</code></pre>\n\n<h3>Examples</h3>\n\n<h3>Sord from scratch, fixed targetFolder and a workflow</h3>\n\n<h4>Arguments</h4>\n\n<pre><code>{\n  sourceElement: {\n    fromScratch: { mask: \"Basic Entry\", type: \"sol.mytype\" }\n  },\n  targetFolder: { objId: \"ARCPATH:/my/target/folder\" },\n  onCreatedElement: {\n    setName: \"My Sord Short Description\",\n    startWorkflow: { name: \"sol.mymodule.myworkflow\", title: \"A workflow title\" }\n  }\n}\n</code></pre>\n\n<h4>Return value</h4>\n\n<pre><code>{\n  objId: \"3982\",\n  flowId: \"89\"\n}\n</code></pre>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-objId' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-onCreatedElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-cfg-onCreatedElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-cfg-onCreatedElement' class='name expandable'>onCreatedElement</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) Defines, which actions will pe performed on the created sord ...</div><div class='long'><p>(optional) Defines, which actions will pe performed on the created sord</p>\n<ul><li><span class='pre'>setName</span> : String<div class='sub-desc'><p>(optional) sets the sords short-description</p>\n</div></li><li><span class='pre'>setOwner</span> : Object<div class='sub-desc'><p>(optional) tries to set <code>sord.userId</code> (owner) ...</p>\n<ul><li><span class='pre'>fromConnection</span> : Boolean (optional)<div class='sub-desc'><p>(optional) ... to the current connection's user</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>toUser</span> : String<div class='sub-desc'><p>(optional) ... to the specified user NOT IMPLEMENTED YET!</p>\n</div></li></ul></div></li><li><span class='pre'>setPermissions</span> : Object (optional)<div class='sub-desc'><p>(optional) sets permissions on the created sord</p>\n<p>Defaults to: <code>{}</code></p></div></li><li><span class='pre'>startWorkflow</span> : Object<div class='sub-desc'><p>(optional) starts a workflow on the created sord</p>\n<ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>workflow template name</p>\n</div></li><li><span class='pre'>title</span> : String (optional)<div class='sub-desc'><p>(optional) specifies the workflow-title</p>\n<p>Defaults to: <code>&quot;Workflow&quot;</code></p></div></li><li><span class='pre'>startMaskStandardWorkflow</span> : String<div class='sub-desc'><p>(optional) start workflow defined in the specified field NOT IMPLEMENTED YET!</p>\n</div></li></ul></div></li></ul></div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-sourceElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-cfg-sourceElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-cfg-sourceElement' class='name expandable'>sourceElement</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) Defines, how the new sord will be created (copy template by objId or create new fromScratch) ...</div><div class='long'><p>(optional) Defines, how the new sord will be created (copy template by <code>objId</code> or create new <code>fromScratch</code>)</p>\n<ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>objId/ARCPATH/GUID of sord to use as template (optional if <code>fromScratch</code> is defined)</p>\n</div></li><li><span class='pre'>fromScratch</span> : Object<div class='sub-desc'><p>(optional) options for creating the sord from Scratch</p>\n<ul><li><span class='pre'>mask</span> : String (optional)<div class='sub-desc'><p>(optional) mask name</p>\n<p>Defaults to: <code>&quot;Basic Entry&quot;</code></p></div></li><li><span class='pre'>type</span> : String<div class='sub-desc'><p>(optional) sord type name</p>\n</div></li></ul></div></li><li><span class='pre'>fromService</span> : Object<div class='sub-desc'><p>(optional) defines a service which must return an Object containing an <code>objId</code> or <code>fromScratch</code> definition</p>\n<ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>IX-RF name</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'><p>(optional) argument which will be passed to the defined service</p>\n<p>Defaults to: <code>{}</code></p></div></li></ul></div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>(optional) additional options used during creation of the new element</p>\n<ul><li><span class='pre'>copySourceAcl</span> : Boolean (optional)<div class='sub-desc'><p>(optional) copy permissions of source element (only when <code>sourceElement.objId</code> is defined)</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></li></ul></div></div></div><div id='cfg-targetFolder' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-cfg-targetFolder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-cfg-targetFolder' class='name expandable'>targetFolder</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) Defines, where the created sord should be put ...</div><div class='long'><p>(optional) Defines, where the created sord should be put</p>\n<ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>objId/ARCPATH/GUID of folder to put created sord in</p>\n</div></li><li><span class='pre'>path</span> : String<div class='sub-desc'><p>(optional) path to folder (which will may created on the fly) NOT IMPLEMENTED YET!</p>\n</div></li><li><span class='pre'>fromService</span> : Object<div class='sub-desc'><p>(optional) defines a service which must return an Object containing an <code>objId</code> (or <code>path</code> not implemented yet, see above) definition</p>\n<ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>IX-RF name</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'><p>(optional) argument which will be passed to the defined service</p>\n<p>Defaults to: <code>{}</code></p></div></li></ul></div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-_moveFct' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-property-_moveFct' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-property-_moveFct' class='name expandable'>_moveFct</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>References objId and flowId ...</div><div class='long'><p>References objId and flowId</p>\n<p>Defaults to: <code>&quot;RF_sol_function_Move&quot;</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-copyElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-method-copyElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-method-copyElement' class='name expandable'>copyElement</a>( <span class='pre'>cfg</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-createSordFromScratch' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-method-createSordFromScratch' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-method-createSordFromScratch' class='name expandable'>createSordFromScratch</a>( <span class='pre'>cfg</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-finalizeCreatedElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-method-finalizeCreatedElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-method-finalizeCreatedElement' class='name expandable'>finalizeCreatedElement</a>( <span class='pre'>cfg</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getServiceResult' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-method-getServiceResult' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-method-getServiceResult' class='name expandable'>getServiceResult</a>( <span class='pre'>element</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-moveElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-method-moveElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-method-moveElement' class='name expandable'>moveElement</a>( <span class='pre'>rights</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rights</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-prepareSourceElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-method-prepareSourceElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-method-prepareSourceElement' class='name expandable'>prepareSourceElement</a>( <span class='pre'>src</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>src</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-prepareTargetFolder' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-method-prepareTargetFolder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-method-prepareTargetFolder' class='name expandable'>prepareTargetFolder</a>( <span class='pre'>tgt</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tgt</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-method-process' class='name expandable'>process</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n<ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>objId of created sord</p>\n</div></li><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>(optional) flowId, if a workflow has been started on the created sord</p>\n</div></li></ul></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-process\" rel=\"sol.common.ix.FunctionBase-method-process\" class=\"docClass\">sol.common.ix.FunctionBase.process</a></p></div></div></div><div id='method-setElementPermissions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-method-setElementPermissions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-method-setElementPermissions' class='name expandable'>setElementPermissions</a>( <span class='pre'>cfg</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-startWorkflowOnElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-method-startWorkflowOnElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-method-startWorkflowOnElement' class='name expandable'>startWorkflowOnElement</a>( <span class='pre'>cfg</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_function_CreateSord' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-static-method-RF_sol_function_CreateSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-static-method-RF_sol_function_CreateSord' class='name expandable'>RF_sol_function_CreateSord</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n...</div><div class='long'><p>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_FunctionName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n</div></li></ul></div></div></div><div id='static-method-onEnterNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-static-method-onEnterNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-static-method-onEnterNode' class='name expandable'>onEnterNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called before a workflow node is activated. ...</div><div class='long'><p>This function is called before a workflow node is activated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The activated node ID</p>\n</div></li></ul></div></div></div><div id='static-method-onExitNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateSord'>sol.common.ix.functions.CreateSord</span><br/><a href='source/sol.common.ix.functions.CreateSord.html#sol-common-ix-functions-CreateSord-static-method-onExitNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateSord-static-method-onExitNode' class='name expandable'>onExitNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called after a workflow node is deactivated. ...</div><div class='long'><p>This function is called after a workflow node is deactivated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The deactivated node ID</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});